/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.bgp;

import ibm.nways.jdm.I18NGiblets;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import java.io.Serializable;

public class ActionBgp
implements StatusMapper,
TableStatusNamer {
    private static String enumBundle = "ibm.nways.bgp.eui.EnumeratedResources";
    private static String bgpBundle = "ibm.nways.bgp.Resources";
    private boolean loggingOn = false;

    public ActionBgp() {
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        if (this.loggingOn) {
            System.out.println("ActionBgp");
        }
        Integer n = (Integer)statusModelInfo.get("Panel.BgpPeerState");
        Serializable[] serializableArray = statusModelInfo.getIndexes();
        String string = serializableArray[0].toString();
        int n2 = n;
        StatusAndExplain statusAndExplain = this.evaluatePeerState(n2, string);
        statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        if (this.loggingOn) {
            System.out.println("ActionBgp - nameThatObject");
        }
        Serializable[] serializableArray = statusModelInfo.getIndexes();
        Object[] objectArray = new Object[]{serializableArray[0].toString()};
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(bgpBundle, "STATUS_NAME", objectArray);
        if (this.loggingOn) {
            System.out.println("args = " + serializableArray[0].toString());
            System.out.println("name = " + i18NMsgFormat.getTranslation());
        }
        return i18NMsgFormat;
    }

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        if (this.loggingOn) {
            System.out.println("ActionBGP - nameThatTableObject");
        }
        I18NString i18NString = new I18NString(bgpBundle, "STATUS_TABLE_BGP");
        return i18NString;
    }

    private StatusAndExplain evaluatePeerState(int n, String string) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = new Object[]{new String(string)};
        objectArray[0] = new I18NMsgFormat(bgpBundle, "bgpstatus", objectArray2);
        if (n == 1) {
            statusAndExplain.statType = StatusType.CRITICAL;
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.bgp.model.PeerModel.Panel.BgpPeerState.idle");
        } else if (n == 2) {
            statusAndExplain.statType = StatusType.CRITICAL;
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.bgp.model.PeerModel.Panel.BgpPeerState.connect");
        } else if (n == 3) {
            statusAndExplain.statType = StatusType.CRITICAL;
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.bgp.model.PeerModel.Panel.BgpPeerState.active");
        } else if (n == 4) {
            statusAndExplain.statType = StatusType.CRITICAL;
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.bgp.model.PeerModel.Panel.BgpPeerState.opensent");
        } else if (n == 5) {
            statusAndExplain.statType = StatusType.CRITICAL;
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.bgp.model.PeerModel.Panel.BgpPeerState.openconfirm");
        } else if (n == 6) {
            statusAndExplain.statType = StatusType.NORMAL;
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.bgp.model.PeerModel.Panel.BgpPeerState.established");
        } else {
            statusAndExplain.statType = StatusType.UNKNOWN;
            objectArray[1] = new I18NString(enumBundle, "unknown");
        }
        statusAndExplain.explain = new I18NGiblets(bgpBundle, "statusorder", objectArray);
        if (this.loggingOn) {
            System.out.println("explain  = " + statusAndExplain.explain.getTranslation());
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NGiblets explain;

        StatusAndExplain() {
            ActionBgp.this = ActionBgp.this;
        }
    }
}

